#ifndef __LOG_HPP__
#define __LOG_HPP__

#include <stdio.h>
#include <stdarg.h> 

#define LOGD(...) __log_print_debug(TAG, __VA_ARGS__)
#define LOGI(...) __log_print_info(TAG, __VA_ARGS__)
#define LOGE(...) __log_print_error(TAG, __VA_ARGS__)
#define TRACE_TAG() LOGI("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! %s(%d)", __FILE__, __LINE__);

static void __log_print_debug(const char* tag, const char* fmt, ...) {
    printf("DEBUG[%s]: ", tag);

    va_list marker;
    va_start(marker, fmt);
    vprintf(fmt, marker);
    va_end(marker);

    printf("\n");
}

static void __log_print_info(const char* tag, const char* fmt, ...) {
    printf("INFO[%s]: ", tag);

    va_list marker;
    va_start(marker, fmt);
    vprintf(fmt, marker);
    va_end(marker);

    printf("\n");
}

static void __log_print_error(const char* tag, const char* fmt, ...) {
    printf("ERROR[%s]: ", tag);

    va_list marker;
    va_start(marker, fmt);
    vprintf(fmt, marker);
    va_end(marker);

    printf("\n");
}

#endif //__LOG_HPP__